<?php
// Error logging for production
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');

// Database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit;
}

date_default_timezone_set('Asia/Dhaka');

// Input
$idNo = $_POST['id_no'] ?? null;
if (!$idNo) {
    echo json_encode(["success" => false, "message" => "Account number missing"]);
    exit;
}
// -------------------------
// Table & Column Name Variables
// -------------------------
$userTable = 'user_account';
$accountLevelsTable = 'account_levels';
$profitTable = 'user_ai_profit';
$dailyCommissionTable = 'daily_obtain_refarrel_commissions';

$colAccountNumber = 'account_number';
$colNetworkId = 'network_id';
$colReferralNetworkId = '9th_level_referral';
$colFirstName = 'first_name';
$colStatus = 'status';
$colProfitAmount = 'profit_amount';
$colProfitDate = 'profit_date';
$colDesignation = 'designation';
$colReferralLevel = '9th_level';
$colAmount = 'amount';
$colDate = 'date';
$colCommissionLevel = 'commission_level';

// -------------------------
// Utility Function
// -------------------------
function executeStatement($conn, $sql, $paramType, $paramValue) {
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        error_log("SQL Prepare Error: " . $conn->error);
        return false;
    }
    if (!empty($paramType) && !empty($paramValue)) {
        $stmt->bind_param($paramType, ...$paramValue);
    }
    if (!$stmt->execute()) {
        error_log("SQL Execute Error: " . $stmt->error);
        return false;
    }
    return $stmt->get_result();
}

// -------------------------
// Fetch user data
// -------------------------
$sql = "SELECT * FROM $userTable WHERE $colAccountNumber = ?";
$userResult = executeStatement($conn, $sql, "s", [$idNo]);

if (!$userResult || $userResult->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "User data not found"]);
    exit;
}

$userData = $userResult->fetch_assoc();
$networkId = $userData[$colNetworkId];

// -------------------------
// Fetch referral accounts
// -------------------------
$sql = "SELECT * FROM $userTable WHERE $colReferralNetworkId = ?";
$referralResult = executeStatement($conn, $sql, "s", [$networkId]);

if (!$referralResult || $referralResult->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "No referral data found"]);
    exit;
}

// -------------------------
// Fetch main account commission
// -------------------------
$sql = "SELECT $colReferralLevel FROM $accountLevelsTable WHERE $colAccountNumber = ?";
$mainCommissionResult = executeStatement($conn, $sql, "s", [$idNo]);
$mainCommission = ($mainCommissionResult && $mainCommissionResult->num_rows > 0) 
                  ? $mainCommissionResult->fetch_assoc()[$colReferralLevel] 
                  : 0;

// -------------------------
// Calculate total commission
// -------------------------
$totalCommission = 0;
while ($referral = $referralResult->fetch_assoc()) {
    $refAccountNo = $referral[$colAccountNumber];

    // Get referral account level and commission
    $sql = "SELECT $colReferralLevel, $colDesignation FROM $accountLevelsTable WHERE $colAccountNumber = ?";
    $refLevelResult = executeStatement($conn, $sql, "s", [$refAccountNo]);

    if ($refLevelResult && $refLevelResult->num_rows > 0) {
        $refLevelData = $refLevelResult->fetch_assoc();




        // Fetch all pending profits (status = 0)


                $sql = "SELECT $colProfitAmount, $colProfitDate 
                        FROM $profitTable 
                        WHERE $colAccountNumber = ? AND $colStatus = 0";
                $profitResult = executeStatement($conn, $sql, "s", [$refAccountNo]);

                $totalProfit = 0;
                $profitDates = [];

                if ($profitResult && $profitResult->num_rows > 0) {
                    while ($profitRow = $profitResult->fetch_assoc()) {
                        $totalProfit += $profitRow[$colProfitAmount];
                        $profitDates[] = $profitRow[$colProfitDate];
                    }

                    // Add commission from all pending profits
                    $totalCommission += ($mainCommission / 100) * $totalProfit;

                    // ✅ Mark these profits as processed (status = 1)
                    $updateSql = "UPDATE $profitTable SET $colStatus = 1 
                                WHERE $colAccountNumber = ? AND $colStatus = 0";
                    $stmt = $conn->prepare($updateSql);
                    if ($stmt) {
                        $stmt->bind_param("s", $refAccountNo);
                        $stmt->execute();
                        $stmt->close();
                    }
                }











    }
}

// -------------------------
// Insert daily commission if not exists
// -------------------------
$currentDate = date('Y-m-d');
$commissionLevel = 'ninth_level';
// with update query


$sql = "SELECT $colAmount FROM $dailyCommissionTable 
        WHERE $colDate = ? AND $colCommissionLevel = ? AND $colAccountNumber = ?";
$existing = executeStatement($conn, $sql, "sss", [$currentDate, $commissionLevel, $idNo]);

if ($existing && $existing->num_rows > 0) {
    // ✅ Update existing row (add new commission to old)
    $row = $existing->fetch_assoc();
    $newAmount = $row[$colAmount] + $totalCommission;

    $updateSql = "UPDATE $dailyCommissionTable 
                  SET $colAmount = ? 
                  WHERE $colDate = ? AND $colCommissionLevel = ? AND $colAccountNumber = ?";
    $stmt = $conn->prepare($updateSql);
    if ($stmt) {
        $stmt->bind_param("dsss", $newAmount, $currentDate, $commissionLevel, $idNo);
        $stmt->execute();
        $stmt->close();
    }
} else {
    // ✅ Insert new row
    $insertSql = "INSERT INTO $dailyCommissionTable 
                  ($colAmount, $colAccountNumber, $colDate, $colCommissionLevel) 
                  VALUES (?,?,?,?)";
    $stmt = $conn->prepare($insertSql);
    if ($stmt) {
        $stmt->bind_param("dsss", $totalCommission, $idNo, $currentDate, $commissionLevel);
        $stmt->execute();
        $stmt->close();
    }
}

// -------------------------
// Get total untransferred commission
// -------------------------
$sql = "SELECT SUM($colAmount) AS total_obtained_commission_amount 
        FROM $dailyCommissionTable 
        WHERE $colStatus = 0 AND $colAccountNumber = ?";
$result = executeStatement($conn, $sql, "s", [$idNo]);
$obtainedCommission = ($result && $result->num_rows > 0) 
                      ? $result->fetch_assoc()['total_obtained_commission_amount'] ?? 0 
                      : 0;

$conn->close();

// -------------------------
// JSON Response
// -------------------------
echo json_encode([
    "success" => true,
    "message" => "User data retrieved",
    "untransferred" => $obtainedCommission
]);
?>
