<?php
// Show all errors (for debugging purposes only - remove in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Binance API credentials
$apiKey = 'IKGOwKvemjvTzfETIumVy0sw42DNGgIp6kQOE1dqEF5oY8NcOQYYkez5Ynkamlha';
$secretKey = 'MQ0kBBSj8Jh2hbPpFWn7KksnqrILR7dDunq8NGVQHj6bJDy5NXaIU2VhRZlgTPd2';

// Configuration
$coin = 'USDT';     // The coin symbol
$network = 'BSC';   // The network name BEP20 (BSC)

// Binance API endpoints (with fallbacks)
$serverTimeEndpoints = [
    'https://api.binance.com/api/v3/time',
    'https://api1.binance.com/api/v3/time',
    'https://api2.binance.com/api/v3/time',
    'https://api3.binance.com/api/v3/time'
];
$depositAddressApiUrl = 'https://api.binance.com/sapi/v1/capital/deposit/address';

// === STEP 1: Get Binance Server Time (try multiple endpoints) === //
$timestamp = null;
$serverError = null;

foreach ($serverTimeEndpoints as $url) {
    $serverTimeCurl = curl_init();
    curl_setopt($serverTimeCurl, CURLOPT_URL, $url);
    curl_setopt($serverTimeCurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($serverTimeCurl, CURLOPT_TIMEOUT, 10);
    curl_setopt($serverTimeCurl, CURLOPT_SSL_VERIFYPEER, true);

    $serverTimeResponse = curl_exec($serverTimeCurl);

    if ($serverTimeResponse !== false) {
        $serverTimeData = json_decode($serverTimeResponse, true);
        if (isset($serverTimeData['serverTime'])) {
            $timestamp = $serverTimeData['serverTime'];
            curl_close($serverTimeCurl);
            break; // Success, exit loop
        }
    } else {
        $serverError = curl_error($serverTimeCurl);
    }

    curl_close($serverTimeCurl);
}

if ($timestamp === null) {
    die(json_encode([
        'success' => false,
        'error' => 'Failed to fetch Binance server time. Last error: ' . $serverError
    ]));
}

// === STEP 2: Generate Signed Request for Deposit Address === //
$queryString = http_build_query([
    'coin' => $coin,
    'network' => $network,
    'timestamp' => $timestamp
]);

$signature = hash_hmac('sha256', $queryString, $secretKey);
$requestUrl = "$depositAddressApiUrl?$queryString&signature=$signature";

// === STEP 3: Make the Deposit Address Request === //
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $requestUrl);
curl_setopt($curl, CURLOPT_HTTPHEADER, [
    "X-MBX-APIKEY: $apiKey"
]);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_TIMEOUT, 10);

$response = curl_exec($curl);

if ($response === false) {
    $error = curl_error($curl);
    curl_close($curl);
    die(json_encode([
        'success' => false,
        'error' => "cURL error while fetching deposit address: $error"
    ]));
}

curl_close($curl);

// Decode response
$data = json_decode($response, true);

// === STEP 4: Output Result === //
header('Content-Type: application/json');

if (isset($data['address'])) {
    echo json_encode([
        'success' => true,
        'address' => $data['address'],
        'tag' => $data['tag'] ?? null,
        'platform' => $data['platform'] ?? $network
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => $data['msg'] ?? 'Unknown error occurred.'
    ]);
}
