<?php
// =========================
// CONFIGURATION
// =========================

// Error logging for production
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');

// Database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    error_log("Database connection failed: " . $conn->connect_error);
    exit;
}

date_default_timezone_set('Asia/Dhaka');

// =========================
// TABLE & COLUMN NAMES
// =========================
$userTable = 'user_account';
$accountLevelsTable = 'account_levels';
$profitTable = 'user_ai_profit';
$dailyCommissionTable = 'daily_obtain_refarrel_commissions';

$colAccountNumber = 'account_number';
$colNetworkId = 'network_id';

$colProfitAmount = 'profit_amount';
$colProfitDate = 'profit_date';

$colAmount = 'amount';
$colDate = 'date';
$colCommissionLevel = 'commission_level';


$colReferralNetworkId = 'fourth_level_refarral';
$colReferralLevel = '4th_level';
$commissionLevel = 'fourth_level';


// =========================
// UTILITY FUNCTION
// =========================
function executeStatement($conn, $sql, $paramType = "", $paramValue = []) {
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        error_log("SQL Prepare Error: " . $conn->error . " | SQL: $sql");
        return false;
    }
    if (!empty($paramType) && !empty($paramValue)) {
        $stmt->bind_param($paramType, ...$paramValue);
    }
    if (!$stmt->execute()) {
        error_log("SQL Execute Error: " . $stmt->error . " | SQL: $sql");
        return false;
    }
    return $stmt->get_result();
}

// =========================
// FETCH ALL USERS
// =========================
$sql = "SELECT $colAccountNumber, $colNetworkId FROM $userTable";
$userResult = $conn->query($sql);

if (!$userResult || $userResult->num_rows === 0) {
    error_log("No users found in $userTable");
    exit;
}

// =========================
// PROCESS EACH USER
// =========================
while ($user = $userResult->fetch_assoc()) {
    $idNo = $user[$colAccountNumber];
    $networkId = $user[$colNetworkId];

    // Fetch main account commission percentage
    $sql = "SELECT $colReferralLevel FROM $accountLevelsTable WHERE $colAccountNumber = ?";
    $mainCommissionResult = executeStatement($conn, $sql, "s", [$idNo]);
    $mainCommission = ($mainCommissionResult && $mainCommissionResult->num_rows > 0) 
                      ? $mainCommissionResult->fetch_assoc()[$colReferralLevel] 
                      : 0;

    // Fetch all referral profits grouped by date
    $sql = "
        SELECT p.$colProfitDate, SUM(p.$colProfitAmount) AS total_profit
        FROM $profitTable p
        INNER JOIN $userTable u ON u.$colAccountNumber = p.$colAccountNumber
        WHERE u.$colReferralNetworkId = ?
        GROUP BY p.$colProfitDate
    ";
    $profitResult = executeStatement($conn, $sql, "s", [$networkId]);

    if (!$profitResult || $profitResult->num_rows === 0) {
        continue; // no referral profits
    }

    while ($row = $profitResult->fetch_assoc()) {
        $profitDate = $row[$colProfitDate];
        $totalProfit = $row['total_profit'];
        $commissionAmount = ($mainCommission / 100) * $totalProfit;
        

        // Check if the row already exists
        $checkSql = "
            SELECT $colAmount 
            FROM $dailyCommissionTable 
            WHERE $colAccountNumber = ? 
            AND $colDate = ? 
            AND $colCommissionLevel = ?
            LIMIT 1
        ";
        $checkResult = executeStatement($conn, $checkSql, "sss", [$idNo, $profitDate, $commissionLevel]);

        if ($checkResult && $checkResult->num_rows > 0) {
            // Row exists → update with new commission
            $updateSql = "
                UPDATE $dailyCommissionTable
                SET $colAmount = ?
                WHERE $colAccountNumber = ? 
                AND $colDate = ? 
                AND $colCommissionLevel = ?
            ";
            executeStatement($conn, $updateSql, "dsss", [$commissionAmount, $idNo, $profitDate, $commissionLevel]);
        } else {
            // Row doesn't exist → insert new
            $insertSql = "
                INSERT INTO $dailyCommissionTable
                ($colAmount, $colAccountNumber, $colDate, $colCommissionLevel)
                VALUES (?, ?, ?, ?)
            ";
            executeStatement($conn, $insertSql, "dsss", [$commissionAmount, $idNo, $profitDate, $commissionLevel]);
        }
    }
}

$conn->close();
?>
