<?php
header('Content-Type: application/json');
$conn = new mysqli("localhost","binarxe2_lumora","Acetone26480","binarxe2_lumora");
if($conn->connect_error){
    die(json_encode(["success"=>false,"message"=>"Database connection failed."]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_POST['user_id'] ?? '';
    $otp = $_POST['otp'] ?? '';

    if (empty($userId) || empty($otp)) {
        echo json_encode(['success' => false, 'message' => 'User ID or OTP missing']);
        exit;
    }

    $stmt = $conn->prepare("SELECT otp_code, expiry_time FROM user_otp WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo json_encode(['success' => false, 'message' => 'No OTP found for this user']);
        exit;
    }

    $row = $result->fetch_assoc();

    if ($row['otp_code'] === $otp) {
        $currentTime = date("Y-m-d H:i:s");
        if ($currentTime > $row['expiry_time']) {
            echo json_encode(['success' => false, 'message' => 'OTP has expired']);
        } else {
            // Optionally delete OTP to prevent reuse
            $deleteStmt = $conn->prepare("DELETE FROM user_otp WHERE user_id = ? AND otp_code = ?");
            $deleteStmt->bind_param("is", $userId, $otp);
            $deleteStmt->execute();

            echo json_encode(['success' => true, 'message' => 'OTP verified']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid OTP']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
