<?php
// Database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Database connection failed."]));
}

// Get input from Flutter app
$idNo     = $_POST['id_no'] ?? '';
$password = $_POST['password'] ?? '';
$deviceId = $_POST['device_id'] ?? '';

// Sanitize user inputs
$idNo     = filter_var($idNo, FILTER_SANITIZE_STRING);
$password = filter_var($password, FILTER_SANITIZE_STRING);
$deviceId = filter_var($deviceId, FILTER_SANITIZE_STRING);

// Validate inputs
if (empty($idNo) || empty($password) || empty($deviceId)) {
    echo json_encode(["success" => false, "message" => "Invalid input. Please make sure all fields are filled correctly."]);
    exit;
}

// Query to find user account
$stmt = $conn->prepare("SELECT * FROM user_account WHERE email = ?");
$stmt->bind_param("s", $idNo);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Incorrect ID or password."]);
    exit;
}

$row = $result->fetch_assoc();
$hashedPasswordFromDB = $row['password'];

// Verify password
if (!password_verify($password, $hashedPasswordFromDB)) {
    echo json_encode(["success" => false, "message" => "Incorrect ID or password."]);
    exit;
}

// Get account number
$accountNumber = $row['account_number'];
$email         = $row['email'];

// Check if there is an active session
$sqlCheckSession = "SELECT * FROM active_sessions WHERE user_id = ? AND expiry_time > ?";
$stmtCheckSession = $conn->prepare($sqlCheckSession);
$currentTime = time();
$stmtCheckSession->bind_param("si", $accountNumber, $currentTime);
$stmtCheckSession->execute();
$resultCheckSession = $stmtCheckSession->get_result();

$sessionId = uniqid();
$expiryTime = strtotime('+1 hour');
$otp = rand(100000, 999999);
$otpExpiry = time() + 300; // 5 min

if ($resultCheckSession->num_rows > 0) {
    $rowSession = $resultCheckSession->fetch_assoc();
    if ($rowSession['device_id'] == $deviceId) {
        // Update existing session
        $sqlUpdateSession = "UPDATE active_sessions SET session_id = ?, expiry_time = ? WHERE user_id = ? AND device_id = ?";
        $stmtUpdateSession = $conn->prepare($sqlUpdateSession);
        $stmtUpdateSession->bind_param("ssss", $sessionId, $expiryTime, $accountNumber, $deviceId);
        $stmtUpdateSession->execute();
    } else {
        echo json_encode(["success" => false, "message" => "Login from multiple devices at the same time is not allowed."]);
        exit;
    }
} else {
    // New session
    $sql = "REPLACE INTO active_sessions (user_id, session_id, device_id, expiry_time) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $accountNumber, $sessionId, $deviceId, $expiryTime);
    $stmt->execute();
}

// Insert or update OTP
$stmtOtp = $conn->prepare("INSERT INTO user_otp(user_id, otp_code, expiry_time) VALUES(?,?,?) 
    ON DUPLICATE KEY UPDATE otp_code=?, expiry_time=?");
$stmtOtp->bind_param("siiii", $accountNumber, $otp, $otpExpiry, $otp, $otpExpiry);
$stmtOtp->execute();

// Final success response
echo json_encode([
    "success"      => true,
    "message"      => "Login successful",
    "sessionToken" => $sessionId,
    "idNo"         => $accountNumber,
    "otp"          => $otp,
    "email"        => $email,
]);

$conn->close();
?>
