<?php
header('Content-Type: application/json');

// Database credentials
$host = "localhost";
$db   = "binarxe2_lumora";
$user = "binarxe2_lumora";
$pass = "Acetone26480";

// Connect to MySQL
$conn = new mysqli($host, $user, $pass, $db);

// Check connection
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]);
    exit;
}

// Get POST data
$user_id   = $_POST['user_id'] ?? '';
$latitude  = $_POST['latitude'] ?? '';
$longitude = $_POST['longitude'] ?? '';

if (empty($user_id) || empty($latitude) || empty($longitude)) {
    echo json_encode([
        "success" => false,
        "message" => "Missing required parameters."
    ]);
    exit;
}

// Check if record exists
$stmt = $conn->prepare("SELECT COUNT(*) FROM user_location WHERE account_number = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($count);
$stmt->fetch();
$stmt->close();

if ($count > 0) {
    // Record exists → UPDATE
    $stmt = $conn->prepare("UPDATE user_location SET lattitude = ?, longitude = ?, updated_at = NOW() WHERE account_number = ?");
    $stmt->bind_param("sss", $latitude, $longitude, $user_id);
    $action = "updated";
} else {
    // Record does not exist → INSERT
    $stmt = $conn->prepare("INSERT INTO user_location (account_number, lattitude, longitude, updated_at) VALUES (?, ?, ?, NOW())");
    $stmt->bind_param("sss", $user_id, $latitude, $longitude);
    $action = "inserted";
}

// Execute and respond
if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Location $action successfully."
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to $action location."
    ]);
}

$stmt->close();
$conn->close();
?>
