<?php
header('Content-Type: application/json');

// Database connection
$host = 'localhost';
$db   = 'binarxe2_lumora';
$user = 'binarxe2_lumora';
$pass = 'Acetone26480';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'DB connection failed']);
    exit;
}

// Function to compress images
function compressImage($source, $destination, $quality = 40) {
    $info = getimagesize($source);
    if (!$info) return false;

    if ($info['mime'] == 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
        imagejpeg($image, $destination, $quality);
    } elseif ($info['mime'] == 'image/png') {
        $image = imagecreatefrompng($source);
        $pngQuality = round((100 - $quality) / 10); // convert 0-100 to 0-9
        imagepng($image, $destination, $pngQuality);
    } else {
        return false; // unsupported format
    }

    imagedestroy($image);
    return true;
}

// Function to handle upload and compression
function handleUpload($file, $upload_dir, $prefix) {
    if (!isset($file) || $file['error'] != UPLOAD_ERR_OK) return null;
    if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

    $filename = uniqid($prefix . '_') . '_' . basename($file['name']);
    $target_path = $upload_dir . $filename;

    if (compressImage($file['tmp_name'], $target_path, 40)) { // quality 40%
        return $target_path;
    }
    return null;
}

// Handle POST data
$account_number = $_POST['account_number'] ?? '';
$nid = $_POST['nid'] ?? '';
$country = $_POST['country'] ?? '';
$bank_account = $_POST['bank_account'] ?? '';
$bank_name = $_POST['bank_name'] ?? '';
$branch_name = $_POST['branch_name'] ?? '';
$present_address = $_POST['present_address'] ?? '';
$permanent_address = $_POST['permanent_address'] ?? '';
$full_name = $_POST['FullName'] ?? '';
$emergency_contact = $_POST['emergency_contact'] ?? '';
$emergency_relation = $_POST['emergency_relation'] ?? '';
$fingerprint_verified = ($_POST['fingerprint_verified'] ?? 'false') === 'true' ? 1 : 0;
$fingerprint_liveness = ($_POST['fingerprint_liveness'] ?? 'false') === 'true' ? 1 : 0;

// Handle uploads with compression
$face_image_path = handleUpload($_FILES['face_image'] ?? null, 'upload/kyc_faces/', 'face');
$front_id_image_path = handleUpload($_FILES['front_id_image'] ?? null, 'upload/kyc_id/', 'front');
$back_id_image_path = handleUpload($_FILES['back_id_image'] ?? null, 'upload/kyc_id/', 'back');

// Insert into database
$stmt = $conn->prepare("INSERT INTO kyc_submissions
    (account_number, nid, country, bank_account, bank_name, branch_name, present_address, permanent_address, full_name, emergency_contact, emergency_relation, fingerprint_verified, fingerprint_liveness, face_image_path, front_id_image_path, back_id_image_path)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param(
    'ssssssssssssssss',
    $account_number, $nid, $country, $bank_account, $bank_name, $branch_name,
    $present_address, $permanent_address, $full_name, $emergency_contact, $emergency_relation,
    $fingerprint_verified, $fingerprint_liveness, $face_image_path, $front_id_image_path, $back_id_image_path
);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
