<?php
header("Content-Type: application/json");

// Database config
$host = "localhost";          // your DB host
$user = "binarxe2_lumora";    // your DB username
$pass = "Acetone26480";       // your DB password
$dbname = "binarxe2_lumora";  // your DB name

// Connect to DB
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed"
    ]);
    exit;
}

// Get user_id from POST
$user_id = isset($_POST['user_id']) ? trim($_POST['user_id']) : '';

if (empty($user_id)) {
    echo json_encode([
        "success" => true,
        "fingerprint_enabled" => false  // no user_id provided → treat as not enabled
    ]);
    exit;
}

// Prepare SQL securely
$stmt = $conn->prepare("SELECT fingerprint_verified FROM kyc_submissions WHERE account_number = ?");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // Convert fingerprint_verified (0/1, tinyint) into boolean
    $enabled = (bool)$row['fingerprint_verified'];

    echo json_encode([
        "success" => true,
        "fingerprint_enabled" => $enabled
    ]);
} else {
    // No user found → treat as fingerprint not available
    echo json_encode([
        "success" => true,
        "fingerprint_enabled" => false
    ]);
}

$stmt->close();
$conn->close();
