<?php
// Database connection parameters
$servername = "localhost"; // Replace with your MySQL server name or IP address
$username = "binarxe2_lumora"; // Replace with your MySQL username
$password = "Acetone26480"; // Replace with your MySQL password
$database = "binarxe2_lumora"; // Replace with your MySQL database name

// Create a connection to the MySQL database
$conn = new mysqli($servername, $username, $password, $database);

// Check if the connection was successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Retrieve data from the HTTP POST request
$accountNumber = $_POST['account_number'];
$transferAmount = $_POST['transfer_amount'];
$address = $_POST['address'];
$currentDate = date("Y-m-d H:i:s");
// Check account balance
$balanceQuery = "SELECT SUM(amount) AS total_balance FROM wallet WHERE account_number = ?";

$stmt = $conn->prepare($balanceQuery);
$stmt->bind_param("s", $accountNumber);
$stmt->execute();
$balanceResult = $stmt->get_result();

if ($balanceResult === false) {
    // Error in executing the query
    $response = array("success" => false, "message" => "Error in balance query: " . $conn->error);
    echo json_encode($response);
    exit();
}

$row = $balanceResult->fetch_assoc();
$accountBalance = $row["total_balance"];

// Check if the account balance is sufficient
if ($accountBalance >= $transferAmount) {
    // Calculate the new balance
    $newBalance = $accountBalance - $transferAmount;


    $deduction = $transferAmount * 0.15;
    $finalBalance = $transferAmount - $deduction; // Fixed the calculation here

    // Update the sender's account balance in the wallet table
    $updateSenderBalanceQuery = "UPDATE wallet SET amount = ? WHERE account_number = ?";

    $stmt = $conn->prepare($updateSenderBalanceQuery);
    $stmt->bind_param("ds", $newBalance, $accountNumber); // Use "ds" for double and string

    if ($stmt->execute()) {
        // Successfully updated the sender's balance, now insert the withdrawal
        $withdrawalQuery = "INSERT INTO withdrawal (account_number, amount, incoming_area,incoming_date,address) VALUES (?, ?, 'Withdrawal Request',?,?)";

        $stmt = $conn->prepare($withdrawalQuery);
        $stmt->bind_param("dsss", $accountNumber, $finalBalance,$currentDate,$address); // Use "ds" for double and string

        if ($stmt->execute()) {
            $deductWithdrawalQuery = "INSERT INTO service_charge_deduction (account_number, deduction_amount, deduction_reason) VALUES (?, ?, 'Withdrawal Request')";

            $deductStmt = $conn->prepare($deductWithdrawalQuery);
            $deductStmt->bind_param("ds", $accountNumber, $deduction); // Use "ds" for double and string

            // Successfully inserted withdrawal
            if ($deductStmt->execute()) {
                $response = array("success" => true, "message" => "Transfer successful");
                echo json_encode($response);
            } else {
                $response = array("success" => false, "message" => "Error inserting service charge deduction: " . $deductStmt->error);
                echo json_encode($response);
            }
        } else {
            $response = array("success" => false, "message" => "Error inserting withdrawal: " . $stmt->error);
            echo json_encode($response);
        }
    } else {
        // Error occurred while updating sender's balance
        $response = array("success" => false, "message" => "Error transferring balance: " . $stmt->error);
        echo json_encode($response);
    }
} else {
    // Insufficient account balance
    $response = array("success" => false, "message" => "Balance is insufficient");
    echo json_encode($response);
}

// Close the database connection
$conn->close();
?>
