<?php
header('Content-Type: application/json');

// DB connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$database = "binarxe2_lumora";
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'DB connection failed']);
    exit;
}

// Get POST data
$data = json_decode(file_get_contents("php://input"), true);
$account_number = $data['account_number'] ?? '';
$amount = floatval($data['amount'] ?? 0);
$type = $data['type'] ?? '';

if (!$account_number || $amount <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
    exit;
}

// Only allow profit_amount transfer
if ($type !== 'profit_amount') {
    echo json_encode(['success' => false, 'message' => 'Only Profit Amount can be transferred to wallet.']);
    exit;
}

$conn->autocommit(false); // Start transaction

try {
    // 1. Check and deduct from user_ai_profit_total
    $stmt = $conn->prepare("SELECT profit_amount FROM user_ai_profit_total WHERE account_number = ? FOR UPDATE");
    $stmt->bind_param("s", $account_number);
    $stmt->execute();
    $stmt->bind_result($current);
    if (!$stmt->fetch()) throw new Exception('Profit Amount account not found');
    $stmt->close();

    if ($current < $amount) throw new Exception('Insufficient Profit Amount balance');

    $stmt = $conn->prepare("UPDATE user_ai_profit_total SET profit_amount = profit_amount - ? WHERE account_number = ?");
    $stmt->bind_param("ds", $amount, $account_number);
    $stmt->execute();
    $stmt->close();

    // 2. Add to wallet
    $stmt = $conn->prepare("SELECT id FROM wallet WHERE account_number = ? FOR UPDATE");
    $stmt->bind_param("s", $account_number);
    $stmt->execute();
    $stmt->bind_result($wallet_id);
    if ($stmt->fetch()) {
        $stmt->close();
        $stmt = $conn->prepare("UPDATE wallet SET amount = amount + ?, last_adjustment_date = NOW() WHERE account_number = ?");
        $stmt->bind_param("ds", $amount, $account_number);
        $stmt->execute();
        $stmt->close();
    } else {
        $stmt->close();
        $email = null; // change this if you can fetch user's email
        $status = 0;
        $stmt = $conn->prepare("INSERT INTO wallet (account_number, email, amount, last_adjustment_date, status) VALUES (?, ?, ?, NOW(), ?)");
        $stmt->bind_param("ssdi", $account_number, $email, $amount, $status);
        $stmt->execute();
        $stmt->close();
    }

    // 3. Log the transfer
    $stmt = $conn->prepare("INSERT INTO wallet_transfer_log (account_number, asset_type, amount, status) VALUES (?, 'profit_amount', ?, 'completed')");
    $stmt->bind_param("sd", $account_number, $amount);
    $stmt->execute();
    $stmt->close();

    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'Transfer successful']);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
$conn->close();
