<?php
header('Content-Type: application/json');

// Database connection parameters
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$database = "binarxe2_lumora";

// Connect to MySQL
$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    echo json_encode(['error' => 'Connection failed: ' . $conn->connect_error]);
    exit;
}

// Read and decode JSON input
$input = json_decode(file_get_contents('php://input'), true);

$account_number = $input['account_number'] ?? '';
$type = $input['type'] ?? '';



if (empty($account_number) || empty($type)) {
    echo json_encode([
        'error' => 'Missing parameters',
        'received_account_number' => $account_number,
        'received_type' => $type
    ]);
    exit;
}

$response = [];

if ($type === 'daily_profit') {
    $stmt = $conn->prepare("SELECT SUM(profit_amount) AS profit_amount FROM user_ai_profit_total WHERE account_number = ? AND transfer_status = 0");
    $stmt->bind_param("s", $account_number);
    $stmt->execute();
    $stmt->bind_result($amount);
    if ($stmt->fetch() && $amount !== null) {
        $response['profit_amount'] = $amount;
    } else {
        $response['profit_amount'] = 0;
    }
    $stmt->close();
} elseif ($type === 'daily_referral_commission') {
    $stmt = $conn->prepare("SELECT SUM(amount) FROM user_referral_commission_asset WHERE account_number = ? AND transfer_status = 0");
    $stmt->bind_param("s", $account_number);
    $stmt->execute();
    $stmt->bind_result($amount);
    if ($stmt->fetch()) {
        $response['amount'] = $amount;
    } else {
        $response['amount'] = 0;
    }
    $stmt->close();

}elseif ($type === 'bonus_amount') {
    $stmt = $conn->prepare("SELECT SUM(amount) AS bonus_amount FROM user_bonus WHERE account_number = ? AND transfer_status = 0");
    $stmt->bind_param("s", $account_number);
    $stmt->execute();
    $stmt->bind_result($amount);
    if ($stmt->fetch()) {
        $response['bonus_amount'] = $amount;
    } else {
        $response['bonus_amount'] = 0;
    }
    $stmt->close();
} else {
    $response['error'] = 'Invalid type specified';
}

$conn->close();
echo json_encode($response);
?>
