<?php
// Database configuration (store this securely)
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

// Create a connection to the database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the database connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Initialize the response array
$response = [];


$idNo = $_POST['id_no'];
$commissionAmount = $_POST['commission_amount'];
// Check if the request method is POST
if ($idNo) {
    // Get the user ID, commission amount, and account number from the request (sanitize inputs)

    


    // Validate the user ID, commission amount, and account number
    if ($idNo) {
        // Fetch the account balance using a prepared statement
        $balanceQuery = $conn->prepare("SELECT amount FROM user_referral_commission_asset WHERE account_number = ?");
        $balanceQuery->bind_param("s", $idNo);
        $balanceQuery->execute();
        $balanceResult = $balanceQuery->get_result();

        if ($balanceResult) {
            $row = $balanceResult->fetch_assoc();
            $accountBalance = $row["amount"];

            // Fetch commissions for the user using a prepared statement
            $currentDate = date('Y-m-d');
            $sql = "SELECT * FROM daily_obtain_refarrel_commissions WHERE status = 0 AND account_number = ?";
            $commissionQuery = $conn->prepare($sql);
            $commissionQuery->bind_param("s", $idNo);
            $commissionQuery->execute();
            $result = $commissionQuery->get_result();

            if ($result->num_rows > 0) {
                $totalCommission = 0;
                $amount_ids = [];

                while ($row = $result->fetch_assoc()) {
                    $totalAmount = $row["amount"];
                    $amount_id = $row["id"];
                    $totalCommission += $totalAmount;
                    $amount_ids[] = $amount_id;
                }

                // Calculate new balance
                $newBalance = $accountBalance + $totalCommission;

                // Start a database transaction for atomic updates
                $conn->begin_transaction();

                // Update user balance using a prepared statement
                $updateBalanceQuery = $conn->prepare("UPDATE user_referral_commission_asset SET amount = ?, last_adjustment_date = ? WHERE account_number = ?");
                $updateBalanceQuery->bind_param("dss", $newBalance, $currentDate, $idNo);

                if ($updateBalanceQuery->execute()) {
                    // Mark commissions as processed using a prepared statement
                    $updateCommissionQuery = $conn->prepare("UPDATE daily_obtain_refarrel_commissions SET status = '1' WHERE id = ?");
                    $success = true;

                    foreach ($amount_ids as $amount_id) {
                        $updateCommissionQuery->bind_param("i", $amount_id);
                        if (!$updateCommissionQuery->execute()) {
                            $success = false;
                            break;
                        }
                    }

                    if ($success) {
                        // All updates successful
                        $conn->commit();
                        $response = [
                            'success' => true,
                            'message' => 'Commission transferred successfully.',
                        ];
                    } else {
                        // Failed to update commission status
                        $conn->rollback();
                        $response = [
                            'success' => false,
                            'message' => 'Failed to update commission status.',
                        ];
                    }
                } else {
                    // Failed to update user balance
                    $conn->rollback();
                    $response = [
                        'success' => false,
                        'message' => 'Failed to update user balance.',
                    ];
                }
            } else {
                // No commissions found for the user
                $response = [
                    'success' => false,
                    'message' => 'No commissions found for the user.',
                ];
            }
        } else {
            // Failed to fetch user balance
            $response = [
                'success' => false,
                'message' => 'Failed to fetch user balance.',
            ];
        }

        // Close prepared statements
        $balanceQuery->close();
        $commissionQuery->close();
        $updateBalanceQuery->close();
        $updateCommissionQuery->close();
    } else {
        // Invalid user ID, commission amount, or account number
        $response = [
            'success' => false,
            'message' => 'Invalid user ID, commission amount, or account number.',
        ];
    }
} else {
    // Invalid request method. Please use POST.
    $response = [
        'success' => false,
        'message' => 'Invalid request method. Please use POST.',
    ];
}

// Set the content type to JSON
header('Content-Type: application/json');

// Encode the response as JSON and output it
echo json_encode($response);
