<?php
// Error logging for production
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');

// Database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit;
}

date_default_timezone_set('Asia/Dhaka');

// Input
$idNo = $_POST['id_no'] ?? null;
if (!$idNo) {
    echo json_encode(["success" => false, "message" => "Account number missing"]);
    exit;
}

// Table & Column Names
$dailyCommissionTable = 'daily_obtain_refarrel_commissions';
$colAmount = 'amount';
$colStatus = 'status';
$colAccountNumber = 'account_number';

// Utility function
function executeStatement($conn, $sql, $paramType, $paramValue) {
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        error_log("SQL Prepare Error: " . $conn->error);
        return false;
    }
    if (!empty($paramType) && !empty($paramValue)) {
        $stmt->bind_param($paramType, ...$paramValue);
    }
    if (!$stmt->execute()) {
        error_log("SQL Execute Error: " . $stmt->error);
        return false;
    }
    return $stmt->get_result();
}

// -------------------------
// Get total untransferred commission
// -------------------------
$sql = "SELECT SUM($colAmount) AS total_obtained_commission_amount 
        FROM $dailyCommissionTable 
        WHERE $colStatus = 0 AND $colAccountNumber = ?";
$result = executeStatement($conn, $sql, "s", [$idNo]);

$obtainedCommission = ($result && $result->num_rows > 0) 
                      ? $result->fetch_assoc()['total_obtained_commission_amount'] ?? 0 
                      : 0;

$conn->close();

// -------------------------
// JSON Response
// -------------------------
echo json_encode([
    "success" => true,
    "untransferred" => $obtainedCommission
]);
?>
