<?php
// Establish database connection
$servername = "localhost";
$username = "binarxe2_trade";
$password = "Acetone26480";
$dbname = "binarxe2_trade";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get input from the Flutter app
if (isset($_POST['id_no'])) {
    $idNo = $_POST['id_no'];

    // Prepare and execute the SQL query for total assets
    $totalAssetsQuery = "SELECT SUM(amount) AS total_assets FROM user_assets WHERE account_number = ?";
    $stmtTotalAssets = $conn->prepare($totalAssetsQuery);
    $stmtTotalAssets->bind_param("s", $idNo);
    $stmtTotalAssets->execute();
    $totalAssetsResult = $stmtTotalAssets->get_result(); // Get the result

    // Prepare and execute the SQL queries for total investments
    $totalInvestmentQuery = "SELECT SUM(total_investment) AS total_investment FROM (
        SELECT SUM(investment) AS total_investment
        FROM user_manual_asset_trading
        WHERE account_number = ? AND status = 0
        UNION ALL
        SELECT SUM(investment) AS total_investment
        FROM user_ai_asset_trading
        WHERE account_number = ? AND status = 0
    ) AS combined_investments";

$stmtTotalInvestment = $conn->prepare($totalInvestmentQuery);
$stmtTotalInvestment->bind_param("ss", $idNo, $idNo);
$stmtTotalInvestment->execute();
$totalInvestmentResult = $stmtTotalInvestment->get_result();



    // Prepare and execute the SQL query for total investments and profits
    $totalProfitQuery = "SELECT SUM(total_profit) AS total_profit FROM (
        SELECT SUM(profit_amount) AS total_profit
        FROM user_ai_profit
        WHERE account_number = ? AND status = 0
        UNION
        SELECT SUM(profit) AS total_profit
        FROM pl_user_manual_trading
        WHERE account_number = ? AND status = 0
    ) AS combined_profits";

    $stmtTotalProfit = $conn->prepare($totalProfitQuery);
    $stmtTotalProfit->bind_param("ss", $idNo, $idNo);
    $stmtTotalProfit->execute();
    $totalProfitResult = $stmtTotalProfit->get_result(); // Get the result

    // Retrieve the total assets value
    $totalAssets = 0;
    if ($totalAssetsResult->num_rows > 0) {
        $totalAssetsData = $totalAssetsResult->fetch_assoc();
        $totalAssets = $totalAssetsData['total_assets'];
    }

    // Retrieve the total profit value
    $totalProfit = 0;
    if ($totalProfitResult->num_rows > 0) {
        $totalProfitData = $totalProfitResult->fetch_assoc();
        $totalProfit = $totalProfitData['total_profit'];
    }

    // Retrieve the total investments value
    $totalInvestment = 0;
    if ($totalInvestmentResult->num_rows > 0) {
        $totalInvestmentData = $totalInvestmentResult->fetch_assoc();
        $totalInvestment = $totalInvestmentData['total_investment'];
    }

    // Prepare the response data
    $responseData = array(
        "total_assets" => $totalAssets,
        "total_investment" => $totalInvestment,
        "total_profit" => $totalProfit
    );

    // Send response back to the Flutter app
    $response = array(
        "success" => true,
        "message" => "Asset and Profit data retrieved",
        "data" => $responseData
    );
    echo json_encode($response);
} else {
    // If id_no is not provided in the request
    $response = array(
        "success" => false,
        "message" => "ID not provided"
    );
    echo json_encode($response);
}

// Close prepared statements and the database connection
$stmtTotalAssets->close();
$stmtTotalProfit->close();
$conn->close();
?>
