<?php
// Establish database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get input from the Flutter app
$idNo = $_POST['id_no'];
date_default_timezone_set('Asia/Dhaka');
// Function to execute a prepared statement
function executeStatement($conn, $sql, $paramType, $paramValue)
{
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Error in preparing the SQL query: " . $conn->error);
    }

    $stmt->bind_param($paramType, $paramValue);
    $stmt->execute();

    return $stmt->get_result();
}

// Function to retrieve user data
function getUserData($conn, $idNo)
{
    $sql = "SELECT * FROM user_account WHERE account_number = ?";
    $paramType = "s"; // Assuming 'account_number' is a string
    $result = executeStatement($conn, $sql, $paramType, $idNo);

    if ($result->num_rows > 0) {
        return $result->fetch_assoc();
    } else {
        return null;
    }
}

// Get user data
$userData = getUserData($conn, $idNo);

if ($userData) {
    $network_id = $userData["network_id"];
    $totalCommission = 0;

    // Retrieve referral data
    $sql = "SELECT * FROM user_account WHERE 9th_level_referral = ?";
    $paramType = "s"; // Assuming 'refarral_network_id' is a string
    $referralData = executeStatement($conn, $sql, $paramType, $network_id);

    if ($referralData->num_rows > 0) {
        $referralDataArray = array();

        while ($referralInfo = $referralData->fetch_assoc()) {
            $Referral_account_number = $referralInfo["account_number"];
            $Referral_name = $referralInfo["first_name"];
            $Referral_network_id = $referralInfo["network_id"];

            $maskedAccountNumber = substr_replace($Referral_account_number, '****', -4);

    $referralDataArray[] = array(
        "account_number" => $maskedAccountNumber,
        "name" => $Referral_name,
        "network_id" => $Referral_network_id,
    );


        }







        // Close database connection
        $conn->close();

        // Create the response data
        $response = array(
            "success" => true,
            "message" => "User data retrieved",
            "referralData" => $referralDataArray
        );
    } else {
        // No referral data found
        $response = array("success" => false, "message" => "No referral data found");
    }
} else {
    // User data not found
    $response = array("success" => false, "message" => "User data not found");
}

// Send response back to the Flutter app as JSON
header('Content-Type: application/json');
echo json_encode($response);
