<?php
// filepath: delete_notification.php

header('Content-Type: application/json');
$servername = "localhost";
$username = "binarxe2_agent";
$password = "Acetone26480";
$dbname = "binarxe2_agent";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';

    if (empty($id)) {
        echo json_encode(['success' => false, 'message' => 'Notification ID required']);
        exit;
    }

    // Validate that the notification exists
    $stmt = $conn->prepare("SELECT id FROM sms WHERE id = ?");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        echo json_encode(['success' => false, 'message' => 'Notification not found']);
        exit;
    }
    $stmt->close();

    // Delete the notification
    $stmt = $conn->prepare("DELETE FROM sms WHERE id = ?");
    $stmt->bind_param("s", $id);
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to delete notification']);
    }
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}