<?php
// Always send JSON
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Database connection
$servername = "localhost";
$username   = "binarxe2_lumora";
$password   = "Acetone26480";
$dbname     = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Database connection failed"
    ]);
    exit;
}

// Get input from Flutter
$idNo = isset($_POST['id_no']) ? $_POST['id_no'] : null;

// Fallback for testing
if (empty($idNo)) {
    $idNo = '+8801622953183';
}

// --- Queries ---

// Total assets
$totalAssetsQuery = "SELECT COALESCE(SUM(amount),0) AS total_assets 
                     FROM user_assets 
                     WHERE account_number = ?";
$stmtTotalAssets = $conn->prepare($totalAssetsQuery);
$stmtTotalAssets->bind_param("s", $idNo);
$stmtTotalAssets->execute();
$totalAssetsResult = $stmtTotalAssets->get_result();
$totalAssets = ($totalAssetsResult->num_rows > 0) 
    ? (float)$totalAssetsResult->fetch_assoc()['total_assets'] 
    : 0.0;

// Total investment
$totalInvestmentQuery = "SELECT COALESCE(SUM(investment),0) AS total_investment 
                         FROM user_ai_asset_trading 
                         WHERE account_number = ? AND status = 0";
$stmtTotalInvestment = $conn->prepare($totalInvestmentQuery);
$stmtTotalInvestment->bind_param("s", $idNo);
$stmtTotalInvestment->execute();
$totalInvestmentResult = $stmtTotalInvestment->get_result();
$totalInvestment = ($totalInvestmentResult->num_rows > 0) 
    ? (float)$totalInvestmentResult->fetch_assoc()['total_investment'] 
    : 0.0;

// Total profit
$totalProfitQuery = "SELECT COALESCE(SUM(profit_amount),0) AS total_profit 
                     FROM user_ai_profit_total 
                     WHERE account_number = ? AND transfer_status = 0";
$stmtTotalProfit = $conn->prepare($totalProfitQuery);
$stmtTotalProfit->bind_param("s", $idNo);
$stmtTotalProfit->execute();
$totalProfitResult = $stmtTotalProfit->get_result();
$totalProfit = ($totalProfitResult->num_rows > 0) 
    ? (float)$totalProfitResult->fetch_assoc()['total_profit'] 
    : 0.0;

// Response
$responseData = [
    "total_assets"     => $totalAssets,
    "total_investment" => $totalInvestment,
    "total_profit"     => $totalProfit
];

echo json_encode([
    "success" => true,
    "message" => "Asset and Profit data retrieved",
    "data"    => $responseData
]);

// Cleanup
$stmtTotalAssets->close();
$stmtTotalInvestment->close();
$stmtTotalProfit->close();
$conn->close();
exit;
?>
