<?php
header('Content-Type: application/json');

// Database configuration
$host = 'localhost';
$db   = 'binarxe2_trade';
$user = 'binarxe2_trade';
$pass = 'Acetone26480';

// Create connection
$conn = new mysqli($host, $user, $pass, $db);

// Check connection
if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed.']);
    exit;
}

// Get account_number from POST
$account_number = isset($_POST['account_number']) ? trim($_POST['account_number']) : '';

if (empty($account_number)) {
    echo json_encode(['status' => 'error', 'message' => 'Account number is required.']);
    exit;
}

$stmt = $conn->prepare("SELECT SUM(amount) as amount FROM user_fuel_money WHERE account_number = ?");
$stmt->bind_param("s", $account_number);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if ($row && $row['amount'] !== null) {
    echo json_encode(['status' => 'success', 'amount' => $row['amount']]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No fuel money found for this account.']);
}


$stmt->close();
$conn->close();
?>