<?php
// Define the response content type as JSON
header('Content-Type: application/json');

// Define Lumora Chain's About Us content as an associative array
$aboutUsContent = [
    'title' => '🌍 L U M O R A   C H A I N 🌍',
    'who_we_are' => 'Lumora Chain is a forward-thinking, multidimensional global institution built on the principles of illumination, innovation, and inclusivity. Inspired by the Latin word Lumo (light/illumination) and the resonance of -ra, our name reflects our mission to spread light, empower people, and create global opportunities. Chain symbolizes our worldwide reach and the interconnected nature of our businesses.',
    'mission' => 'To empower individuals and communities with transparent, technology-driven, and sustainable opportunities across multiple industries. We are committed to building wealth, trust, and innovation for a brighter tomorrow.',
    'vision' => 'A borderless world where finance, technology, and society converge — unlocking limitless possibilities. Lumora Chain aims to become a global symbol of illumination and progress, guiding people to long-term success and prosperity.',
    'business_model' => [
        'deposits_returns' => [
            '200-day cycle',
            'Paid 6 days a week (Mon–Sat)',
            '$50 - 1,999 → $1.00 daily | $2,000-4,999 → $1.20 daily | $5,000 - 9,999 → $1.30 daily | $10,000 + → $1.50 daily'
        ],
        'withdrawals' => [
            'Minimum withdrawal $20',
            'Three wallets: Daily ROI, Referral commissions, Bonuses',
            'Any withdrawals will be subject to a 15% deduction for club bonuses.: 30% → EON Club, 70% → ODYSSEY Club'
        ],
        'team_building' => 'Members grow teams through 3 links (50%, 30%, 20%).
        
        ROI commissions available up to 10 levels with a maximum of 25%.'
    ],
    
    
    'rewards_designations' => [
    'Lumo'     => 'Entry, $50 deposit, ROI achiever (Eligibility Criteria: Self_Deposit - $50 | Target_Deposit - N/A)',
    'Elite'    => 'Local Tour or $100 (Eligibility Criteria: Self_Deposit - $100 | Target_Deposit - $5,000)',
    'Vega'     => 'Local Tour or $500 (Eligibility Criteria: Self_Deposit - $500 | Target_Deposit - $12,000)',
    'Apex'     => 'International Tour or $1,000 (Eligibility Criteria: Self_Deposit - $1,000 | Target_Deposit - $18,000)',
    'Zenith'   => 'International Tour or $2,000 (Eligibility Criteria: Self_Deposit - $2,000 | Target_Deposit - $30,000)',
    'Orbit'    => '150cc Bike or $3,000 (Eligibility Criteria: Self_Deposit - $3,000 | Target_Deposit - $50,000)',
    'Pinnacle' => '350cc Bike or $5,000 or Lifetime $1,000 Salary (Eligibility Criteria: Self_Deposit - $5,000 | Target_Deposit - $75,000)',
    'Crest'    => 'Nano Car or $8,000 (Eligibility Criteria: Self_Deposit - $8,000 | Target_Deposit - $100,000)',
    'Eon'      => 'Private Car or $10,000 & EON Club profit share (Eligibility Criteria: Self_Deposit - $10,000 | Target_Deposit - $150,000)',
    'Infinity' => 'Office Setup: $20,000 one-time décor cost + $500 monthly rent (Eligibility Criteria: Self_Deposit - $20,000 | Target_Deposit - $500,000)',
    'Odyssey'  => 'Duplex or $50,000 and ODYSSEY Club profit share for life (Eligibility Criteria: Self_Deposit - $50,000 | Target_Deposit - $1,000,000)'
],
    
    
    'clubs' => [
        'EON' => '30% of withdrawal fees shared monthly among members until Odyssey is achieved.',
        'Odyssey' => '70% of withdrawal fees shared monthly for life.'
    ],
    
    
    'title_meanings' => [
        'Lumo' => 'Light, brightness',
        'Elite' => 'Leadership',
        'Vega' => 'Team building begins',
        'Apex' => 'Top performance',
        'Zenith' => 'Final stage of climbing',
        'Orbit' => 'Expansion',
        'Pinnacle' => 'Market dimension',
        'Crest' => 'Top achiever',
        'Eon' => 'Long-term success',
        'Infinity' => 'Legendary status',
        'Odyssey' => 'Epic journey, ultimate mastery'
    ],
    
    
    'ecosystem' => [
        'LumoraBook' => 'Social media (like Facebook)',
        'LumoraTube' => 'Video content sharing (like YouTube)',
        'LumoraPay' => 'Mobile banking & digital payments',
        'LumoraX' => 'Crypto trading & digital asset exchange',
        'LumoraAI' => 'Artificial Intelligence (like ChatGPT)',
        'LumoraTrade' => 'Stock, forex & commodities trading',
        'LumoraMart' => 'E-commerce (like Amazon/Alibaba)',
        'LumoraCloud' => 'Cloud storage & data solutions',
        'LumoraStream' => 'Video & music streaming',
        'LumoraLearn' => 'Online education & skill development',
        'LumoraWork' => 'Freelancing & remote work',
        'LumoraShop' => 'Online shopping & product marketplace',
        'LumoraBank' => 'Digital banking & investment services',
        'LumoraNews' => 'Online news & media',
        'LumoraHealth' => 'Telemedicine & healthcare services'
    ],
    
    
    'values' => [
        'Transparency & Trust',
        'Innovation & Technology',
        'Global Reach',
        'Empowerment',
        'Sustainability'
    ],
    'tagline' => '✨ Lumora Chain – Illuminating the Future, Together.'
];

// Encode the content as JSON and send it as the response
echo json_encode($aboutUsContent, JSON_PRETTY_PRINT);
?>
