<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 0);

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['account_number'])) {
    echo json_encode(["success" => false, "message" => "Account number required"]);
    exit;
}

$account_number = $_POST['account_number'] ?? '';

$conn = new mysqli("localhost","binarxe2_lumora","Acetone26480","binarxe2_lumora");
if ($conn->connect_error) {
    echo json_encode(["success"=>false,"message"=>"DB connection failed"]);
    exit;
}

// Referral columns
$referralColumns = [
    1 => "refarral_network_id",
    2 => "second_level_refarral",
    3 => "third_level_refarral",
    4 => "fourth_level_refarral",
    5 => "fifth_level_refarral",
    6 => "6th_level_referral",
    7 => "7th_level_referral",
    8 => "8th_level_referral",
    9 => "9th_level_referral",
    10 => "10th_level_referral"
];

// Fetch user's network_id
$stmt = $conn->prepare("SELECT network_id FROM user_account WHERE account_number=?");
$stmt->bind_param("s",$account_number);
$stmt->execute();
$res = $stmt->get_result();
if($res->num_rows==0){ echo json_encode(["success"=>false,"message"=>"User not found"]); exit; }
$network_id = $res->fetch_assoc()['network_id'];

// Designation rules
$designations = [
    ["name"=>"LUMO","own_invest"=>50,"target"=>0],
    ["name"=>"ELITE","own_invest"=>100,"target"=>5000],
    ["name"=>"VEGA","own_invest"=>500,"target"=>12000],
    ["name"=>"APEX","own_invest"=>1000,"target"=>18000],
    ["name"=>"ZENITH","own_invest"=>2000,"target"=>30000],
    ["name"=>"ORBIT","own_invest"=>3000,"target"=>50000],
    ["name"=>"PINNACLE","own_invest"=>5000,"target"=>75000],
    ["name"=>"CREST","own_invest"=>8000,"target"=>100000],
    ["name"=>"EON","own_invest"=>10000,"target"=>150000],
    ["name"=>"INFINITY","own_invest"=>20000,"target"=>500000],
    ["name"=>"ODYSSEY","own_invest"=>50000,"target"=>1000000],
];

// Recursive function to get all referrals with level info
function getReferrals($conn, $network_id, $referralColumns, $level=1){
    $all = [];
    foreach($referralColumns as $col){
        $stmt = $conn->prepare("SELECT account_number, network_id FROM user_account WHERE $col=?");
        $stmt->bind_param("s", $network_id);
        $stmt->execute();
        $res = $stmt->get_result();
        while($row = $res->fetch_assoc()){
            $all[] = ["account_number"=>$row['account_number'], "network_id"=>$row['network_id'], "level"=>$level];
            $sub = getReferrals($conn, $row['network_id'], $referralColumns, $level+1);
            $all = array_merge($all, $sub);
        }
    }
    return $all;
}

// Get own investment
function getOwnInvest($conn, $account_number){
    $stmt=$conn->prepare("SELECT SUM(investment) as total_invest FROM user_ai_asset_trading WHERE account_number=? AND status=0");
    $stmt->bind_param("s",$account_number);
    $stmt->execute();
    return (float)($stmt->get_result()->fetch_assoc()['total_invest'] ?? 0);
}

// Function to calculate weighted investment from groups
function calculateWeightedInvestment($groupInvests){
    rsort($groupInvests);
    $weighted = 0;
    if(count($groupInvests)>=1) $weighted += $groupInvests[0]*0.5;
    if(count($groupInvests)>=2) $weighted += $groupInvests[1]*0.3;
    if(count($groupInvests)>=3) $weighted += $groupInvests[2]*0.2;
    return $weighted;
}

// Main function to calculate designation with detailed info
function calculateDesignationDetailed($conn, $account_number, $referralColumns, $designations){
    $own_invest = getOwnInvest($conn, $account_number);

    // First level referrals
    $stmt = $conn->prepare("SELECT account_number, network_id FROM user_account WHERE refarral_network_id=(SELECT network_id FROM user_account WHERE account_number=?)");
    $stmt->bind_param("s",$account_number);
    $stmt->execute();
    $res = $stmt->get_result();
    $firstLevel = [];
    while($row = $res->fetch_assoc()){
        $firstLevel[] = $row;
    }

    // Prepare groups
    $groupDetails = [];
    $groupInvests = [];
    foreach($firstLevel as $acct){
        $subs = getReferrals($conn, $acct['network_id'], $referralColumns, 2); // level 2+ subs
        $total = getOwnInvest($conn, $acct['account_number']);
        $subsDetails = [];
        foreach($subs as $sub){
            $sub_invest = getOwnInvest($conn, $sub['account_number']);
            $total += $sub_invest;
            $subsDetails[] = ["account_number"=>$sub['account_number'], "level"=>$sub['level'], "investment"=>$sub_invest];
        }
        $groupInvests[] = $total;
        $groupDetails[] = [
            "account_number"=>$acct['account_number'],
            "level"=>1,
            "own_invest"=>$total,
            "sub_accounts"=>$subsDetails
        ];
    }

    $weightedInvest = calculateWeightedInvestment($groupInvests);
    $totalInvest = $own_invest + $weightedInvest;

    $stepsCompleted = [];
    foreach($designations as $desig){
        $status = ($totalInvest >= $desig['target']) ? "completed" : "current";
        $stepsCompleted[] = [
            "designation"=>$desig['name'],
            "own_invest"=> $own_invest,
            "weighted_invest"=> $weightedInvest,
            "total_invest"=>$totalInvest,
            "status"=>$status,
            "groups"=>$groupDetails
        ];
        if($status=="current") break;
    }

    $nextDesignation = null;
    $remaining = 0;
    foreach($designations as $desig){
        if($totalInvest < $desig['target']){
            $nextDesignation = $desig['name'];
            $remaining = $desig['target'] - $totalInvest;
            break;
        }
    }

    $currentDesignation = $stepsCompleted[count($stepsCompleted)-1]['designation'];

    return [
        "designation"=>$currentDesignation,
        "own_invest"=>$own_invest,
        "weighted_invest"=>$weightedInvest,
        "total_invest"=>$totalInvest,
        "steps_completed"=>$stepsCompleted,
        "next_designation"=>$nextDesignation,
        "remaining_target_for_next"=>$remaining
    ];
}

$data = calculateDesignationDetailed($conn, $account_number, $referralColumns, $designations);

$conn->close();
echo json_encode(["success"=>true,"data"=>$data]);
?>
