<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 0);

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['account_number'])) {
    echo json_encode(["success" => false, "message" => "Account number required"]);
    exit;
}

$account_number = $_POST['account_number'] ?? '';
$load_details = $_POST['load_details'] ?? 0; // 0=basic, 1=full

$conn = new mysqli("localhost","binarxe2_lumora","Acetone26480","binarxe2_lumora");
if ($conn->connect_error) {
    echo json_encode(["success"=>false,"message"=>"DB connection failed"]);
    exit;
}

// Referral columns
$referralColumns = [
    1 => "refarral_network_id",
    2 => "second_level_refarral",
    3 => "third_level_refarral",
    4 => "fourth_level_refarral",
    5 => "fifth_level_refarral",
    6 => "6th_level_referral",
    7 => "7th_level_referral",
    8 => "8th_level_referral",
    9 => "9th_level_referral",
    10 => "10th_level_referral"
];

// Fetch user network_id
$stmt = $conn->prepare("SELECT network_id FROM user_account WHERE account_number=?");
$stmt->bind_param("s",$account_number);
$stmt->execute();
$res = $stmt->get_result();
if($res->num_rows==0){ echo json_encode(["success"=>false,"message"=>"User not found"]); exit; }
$network_id = $res->fetch_assoc()['network_id'];

// Function to fetch referral basic info
function fetchReferralBasic($conn,$network_id,$referralColumns){
    $result=[];
    foreach($referralColumns as $level=>$col){
        $stmt=$conn->prepare("SELECT account_number, first_name, network_id FROM user_account WHERE $col=?");
        $stmt->bind_param("s",$network_id);
        $stmt->execute();
        $res=$stmt->get_result();
        $levelData=[];
        while($row=$res->fetch_assoc()){
            $stmt2=$conn->prepare("SELECT SUM(investment) as total_invest FROM user_ai_asset_trading WHERE account_number=? AND status=0");
            $stmt2->bind_param("s",$row['account_number']);
            $stmt2->execute();
            $total_invest=$stmt2->get_result()->fetch_assoc()['total_invest']??0;

            $levelData[]=[
                "account_number"=>$row['account_number'],
                "first_name"=>$row['first_name'],
                "network_id"=>$row['network_id'],
                "total_invest"=>$total_invest
            ];
        }
        if(!empty($levelData)) $result[$level]=$levelData;
    }
    return $result;
}

// Function to fetch full details (profit + referrals)
function fetchReferralDetails($conn,$account_number,$referralColumns){
    // profit history
    $stmt=$conn->prepare("SELECT profit_date, profit_amount FROM user_ai_profit WHERE account_number=? ORDER BY profit_date DESC");
    $stmt->bind_param("s",$account_number);
    $stmt->execute();
    $profits=[];
    $res=$stmt->get_result();
    while($row=$res->fetch_assoc()){
        $profits[]=["date"=>$row['profit_date'],"amount"=>$row['profit_amount']];
    }

    // referrals
    $stmt=$conn->prepare("SELECT network_id FROM user_account WHERE account_number=?");
    $stmt->bind_param("s",$account_number);
    $stmt->execute();
    $network_id=$stmt->get_result()->fetch_assoc()['network_id'];

    $referrals=[];
    foreach($referralColumns as $level=>$col){
        $stmt=$conn->prepare("SELECT account_number, first_name, network_id FROM user_account WHERE $col=?");
        $stmt->bind_param("s",$network_id);
        $stmt->execute();
        $res=$stmt->get_result();
        $levelData=[];
        while($row=$res->fetch_assoc()){
            $stmt2=$conn->prepare("SELECT SUM(investment) as total_invest FROM user_ai_asset_trading WHERE account_number=? AND status=0");
            $stmt2->bind_param("s",$row['account_number']);
            $stmt2->execute();
            $total_invest=$stmt2->get_result()->fetch_assoc()['total_invest']??0;

            $levelData[]=[
                "account_number"=>$row['account_number'],
                "first_name"=>$row['first_name'],
                "network_id"=>$row['network_id'],
                "total_invest"=>$total_invest
            ];
        }
        if(!empty($levelData)) $referrals[$level]=$levelData;
    }

    return ["profit_history"=>$profits,"referrals"=>$referrals];
}

// Decide what to return
if($load_details==0){
    $data=fetchReferralBasic($conn,$network_id,$referralColumns);
}else{
    $data=fetchReferralDetails($conn,$account_number,$referralColumns);
}

$conn->close();
echo json_encode(["success"=>true,"data"=>$data]);
?>
