<?php
// Database connection
$servername = "localhost";
$username = "binarxe2_lumora";
$password = "Acetone26480";
$dbname = "binarxe2_lumora";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get input from Flutter app
$idNo = $_POST['id_no'];
$password = $_POST['password'];
$deviceId = $_POST['device_id']; // Device ID input

// Sanitize user inputs
$idNo = filter_var($idNo, FILTER_SANITIZE_STRING);
$password = filter_var($password, FILTER_SANITIZE_STRING);
$deviceId = filter_var($deviceId, FILTER_SANITIZE_STRING);

// Validate inputs
if (empty($idNo) || empty($password) || empty($deviceId)) {
    $response = array("success" => false, "message" => "Invalid input. Please make sure all fields are filled correctly.");
    echo json_encode($response);
    exit;
}

// Query to find user account
$stmt = $conn->prepare("SELECT * FROM user_account WHERE email = ?");
$stmt->bind_param("s", $idNo);
$stmt->execute();

$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $hashedPasswordFromDB = $row['password'];

    // Verify password
    if (password_verify($password, $hashedPasswordFromDB)) {

                $accountNumber = null;
                $account_stmt = $conn->prepare("SELECT account_number FROM user_account WHERE email = ?");
                $account_stmt->bind_param("s", $idNo);
                $account_stmt->execute();
                $account_result = $account_stmt->get_result();
                if ($account_row = $account_result->fetch_assoc()) {
                    $accountNumber = $account_row['account_number'];
                }
                $account_stmt->close();


        // Check if there is an active session
        $sqlCheckSession = "SELECT * FROM active_sessions WHERE user_id = ? AND expiry_time > ?";
        $stmtCheckSession = $conn->prepare($sqlCheckSession);
        $currentTime = time();
        $stmtCheckSession->bind_param("si", $idNo, $currentTime);
        $stmtCheckSession->execute();
        $resultCheckSession = $stmtCheckSession->get_result();

        if ($resultCheckSession->num_rows > 0) {
            $rowSession = $resultCheckSession->fetch_assoc();
            if ($rowSession['device_id'] == $deviceId) {
                // Same device, update session
                $sessionId = uniqid();
                $expiryTime = strtotime('+1 hour');
                $sqlUpdateSession = "UPDATE active_sessions SET session_id = ?, expiry_time = ? WHERE user_id = ? AND device_id = ?";
                $stmtUpdateSession = $conn->prepare($sqlUpdateSession);
                $stmtUpdateSession->bind_param("ssss", $sessionId, $expiryTime, $idNo, $deviceId);
                $stmtUpdateSession->execute();

                $response = array("success" => true, "message" => "Login successful", "sessionToken" => $sessionId);
            } else {
                // Different device - reject login
                $response = array("success" => false, "message" => "Login from multiple devices at the same time is not allowed.");
            }
        } else {
            // New session
            $sessionId = uniqid();
            $userId = $row['account_number'];
            $expiryTime = strtotime('+1 hour');
            $sql = "REPLACE INTO active_sessions (user_id, session_id, device_id, expiry_time) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssss", $userId, $sessionId, $deviceId, $expiryTime);
            $stmt->execute();

            $response = array(
            "success" => true,
            "message" => "Login successful",
            "sessionToken" => $sessionId,
            "idNo" => $accountNumber // send account number, not email
        );
        }
    } else {
        // Wrong password
        $response = array("success" => false, "message" => "Incorrect ID or password.");
    }
} else {
    // Account not found
    $response = array("success" => false, "message" => "Incorrect ID or password.");
}

// Send response
echo json_encode($response);

// Close connections
$stmt->close();
$conn->close();
?>
