<?php
// Database connection parameters
$servername = "localhost"; // Replace with your MySQL server name or IP address
$username = "binarxe2_trade"; // Replace with your MySQL username
$password = "Acetone26480"; // Replace with your MySQL password
$database = "binarxe2_trade"; // Replace with your MySQL database name

// Create a connection to the MySQL database
$conn = new mysqli($servername, $username, $password, $database);

// Check if the connection was successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Retrieve data from the HTTP POST request
$account_number = $_POST['account_number'];
$nid = $_POST['nid'];
$bank_account = $_POST['bank_account'];
$bank_name = $_POST['bank_name'];
$branch_name = $_POST['branch_name'];
$present_address = $_POST['present_address'];
$permanent_address = $_POST['permanent_address'];
$country = $_POST['country'];

// Check if the account number already exists
$check_sql = "SELECT * FROM kyc WHERE account_number = ?";
$check_stmt = $conn->prepare($check_sql);
$check_stmt->bind_param("s", $account_number);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    // Account number exists, perform an update
    $sql = "UPDATE kyc SET
            nid = ?,
            bank_account = ?,
            bank_name = ?,
            branch_name = ?,
            present_address = ?,
            permanent_address = ?,
            country = ?
            WHERE account_number = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Error in preparing the SQL statement: " . $conn->error);
    }
    $stmt->bind_param("ssssssss", $nid, $bank_account, $bank_name, $branch_name, $present_address, $permanent_address, $country, $account_number);
} else {
    // Account number does not exist, perform an insert
    $sql = "INSERT INTO kyc (account_number, nid, bank_account, bank_name, branch_name, present_address, permanent_address, country)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Error in preparing the SQL statement: " . $conn->error);
    }
    $stmt->bind_param("ssssssss", $account_number, $nid, $bank_account, $bank_name, $branch_name, $present_address, $permanent_address, $country);
}

// Execute the SQL statement and handle the response
if ($stmt->execute()) {
    $response = array('status' => 'success', 'message' => ($check_result->num_rows > 0) ? 'Update successful' : 'Signup successful');
} else {
    $response = array('status' => 'error', 'message' => ($check_result->num_rows > 0) ? 'Update failed' : 'Signup failed');
}

echo json_encode($response);

// Close the statement and the database connection
$stmt->close();
$check_stmt->close();
$conn->close();
?>
