<?php
// Debug logging function
function debug_log($message) {
    $logFile = __DIR__ . "/debug.log"; // log file in same directory
    $timestamp = date("Y-m-d H:i:s");
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Database connection parameters
$servername = "localhost"; // Replace with your MySQL server name or IP address
$username = "binarxe2_lumora"; // Replace with your MySQL username
$password = "Acetone26480"; // Replace with your MySQL password
$database = "binarxe2_lumora"; // Replace with your MySQL database name

debug_log("Initializing database connection...");

// Create a connection to the MySQL database
$conn = new mysqli($servername, $username, $password, $database);

// Check the connection
if ($conn->connect_error) {
    debug_log("Database connection failed: " . $conn->connect_error);
    die("Connection failed: " . $conn->connect_error);
}
debug_log("Database connection established successfully.");

// Check if the request method is POST.
debug_log("Request method: " . $_SERVER["REQUEST_METHOD"]);
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    debug_log("POST request received.");

    if (isset($_POST["email"]) && isset($_POST["nid_card_number"])) {
        debug_log("Received parameters: email=" . $_POST["email"] . ", nid_card_number=" . $_POST["nid_card_number"]);

        // Find Account Logic
        $email = $_POST["email"];
        $nidCardNumber = $_POST["nid_card_number"];

        // Prepare SQL
        $sql = "SELECT user_account.*, kyc.nid
                FROM user_account
                INNER JOIN kyc ON user_account.email = ? AND kyc.nid = ?";
        $stmt = $conn->prepare($sql);

        if (!$stmt) {
            debug_log("SQL prepare failed: " . $conn->error);
            die(json_encode(array("error" => "SQL prepare failed")));
        }
        debug_log("SQL prepared successfully.");

        $stmt->bind_param("ss", $email, $nidCardNumber);
        debug_log("SQL parameters bound: email=$email, nid=$nidCardNumber");

        $stmt->execute();
        debug_log("SQL executed.");

        $result = $stmt->get_result();
        debug_log("Query returned " . $result->num_rows . " rows.");

        if ($result->num_rows == 1) {
            // Account found
            $response = array("found" => true);
            debug_log("Account found for email=$email and nid=$nidCardNumber.");
            echo json_encode($response);
        } else {
            // Account not found
            $response = array("found" => false);
            debug_log("No account found for email=$email and nid=$nidCardNumber.");
            echo json_encode($response);
        }

        $stmt->close();
        debug_log("Statement closed.");
    } else {
        debug_log("Required POST parameters missing.");
    }
} else {
    debug_log("Non-POST request received, ignoring.");
}

// Close the database connection.
$conn->close();
debug_log("Database connection closed.");
?>
